﻿/**
 * @fileoverview 主脚本
 * @author sunnyjiang
 * @version 1.1
 */

// 程序入口
/**
 * 全局变量，慎用
 */
/*
var global = {
	currentTab: null,	
};*/

/**
 * @namespace All actions here
 */
var action = {};

/**
 * init all functions and events
 */
action.beforeShow = function(){
	aero.setAero();	
	
	// 页面崩溃infobar
	window.infobar = new qqbrowser.widgets.infobar("infobar");
	infobar.setClass("qqbrowser-infobar");
	infobar.onShow(function() {
		qqbrowser.log.info("littleli: infobar.onShow");
		qqbrowser.skin.window.popAboveWeb();
		qqbrowser.log.info("littleli: after popAboveWeb" + window.layout);
		layout.resize();
	});
	infobar.onHide(function() {
		qqbrowser.log.info("littleli:" + layout);
		layout.resize();
	});
	infobar.crashFirstTimeText = "页面发生错误，已帮您拦截并自动恢复";
	infobar.crashText = "页面多次发生错误，若要继续浏览，您可以尝试点击";
	infobar.zombieText = "页面失去响应，您可以继续等待，或尝试点击";
	infobar.setText(infobar.crashText);
	window.infobar.refreshButton = new qqbrowser.widgets.button("infobar-refreshbutton");
	window.infobar.refreshButton.setText("刷新");
	window.infobar.addAction(window.infobar.refreshButton);
	window.infobar.refreshButton.onclick(function(event){
		qqbrowser.page.reload(browser.getCurrentPageId());
		window.infobar.show(false);
	});
	infobar.crashPage = new qqbrowser.widgets.page("crash-page");
	
	infobar.insert(document.getElementById("info-box"));

// little	
	// 密码记录infobar
	window.savePWinfobar = new qqbrowser.widgets.infobar("savePWinfobar");
	savePWinfobar.setClass("qqbrowser-SavePWd-infobar");
	savePWinfobar.onShow(function() {
		layout.resize();
	});
	savePWinfobar.onHide(function() {
		window.tabInfo[window.currentPageId - 1] = undefined;
		window.currentPageId = -1;
		layout.resize();
	});
    
	// 测试页面相关的密码保存功能
	window.tabInfo = new Array(100);
	// 记录密码保存infobar属于哪个page
	window.currentPageId = -1;
	

	savePWinfobar.firstText = "想让QQ浏览器保存此网站的密码吗？";
	savePWinfobar.secondText = '<span class = "new-qqbrowser-widget-infobar-text">   (保存后下次在本机访问无需手动输入)</span>';
	savePWinfobar.finalText = savePWinfobar.firstText + savePWinfobar.secondText;
	savePWinfobar.setHtml(savePWinfobar.finalText);
	window.savePWinfobar.setIcon("key.png");
	
	// 记住按钮
	window.savePWinfobar.rememberButton = new qqbrowser.widgets.button("savePWinfobar-rememberButton");
	window.savePWinfobar.rememberButton.setText("保存");
	// 不记住按钮
	window.savePWinfobar.norememberButton = new qqbrowser.widgets.button("savePWinfobar-norememberButton");
	window.savePWinfobar.norememberButton.setText("取消");
	// 了解此功能按钮
	window.savePWinfobar.refButton = new qqbrowser.widgets.button("savePWinfobar-refButton");	
	window.savePWinfobar.refButton.setText("了解此功能");
	// 不再提醒此网站按钮
	window.savePWinfobar.neverButton = new qqbrowser.widgets.button("savePWinfobar-neverButton");
	window.savePWinfobar.neverButton.setText("以后不再提示");
	


	// 注册各个按钮行为
	window.savePWinfobar.addAction(window.savePWinfobar.rememberButton);
	window.savePWinfobar.addAction(window.savePWinfobar.norememberButton);
	window.savePWinfobar.addAction(window.savePWinfobar.refButton);
	window.savePWinfobar.addAction(window.savePWinfobar.neverButton);	
	
	// 重新设置"了解此功能"的样式
	window.savePWinfobar.refButton.setClass("savePWinfobar-refButton");
	
	
	// 绑定按钮的事件处理程序
	window.savePWinfobar.rememberButton.onclick(function(event){
		// 调用后台api的接口
		var extId ="{75A78384-8765-4852-ABB7-8D5FA8BF48E2}";
		var cmd = {};
		cmd.command = "savePwd";
		cmd.pageId = window.currentPageId;
		//cmd.title=savePWinfobar.webpageText;
		qqbrowser.extension.sendRequest(extId, cmd, function() {});
		window.savePWinfobar.show(false);
	});
	window.savePWinfobar.norememberButton.onclick(function(event){
		// 调用后台api的接口
		var extId ="{75A78384-8765-4852-ABB7-8D5FA8BF48E2}";
		var cmd = {};
		cmd.command = "noSavePwd";
		cmd.pageId = window.currentPageId;
		qqbrowser.extension.sendRequest(extId, cmd, function() {});
		window.savePWinfobar.show(false);
	});
	window.savePWinfobar._close.onclick(function(event){
		// 调用后台api的接口
		var extId ="{75A78384-8765-4852-ABB7-8D5FA8BF48E2}";
		var cmd = {};
		cmd.command = "noSavePwd";
		cmd.pageId = window.currentPageId;
		qqbrowser.extension.sendRequest(extId, cmd, function() {});
		window.savePWinfobar.show(false);
	});
	
	window.savePWinfobar.refButton.onclick(function(event){
		// 打开相应的网页
		try {
	    qqbrowser.tabs.create( "http://service.qq.com/info/61361.html", 0, qqbrowser.window.currentId() , 0 );
		} catch(e) {
		}
	});
	window.savePWinfobar.neverButton.onclick(function(event){
		// 调用后台api的接口
		var obj = {};
		obj.autoFillTip = 0;
		try{
	    	qqbrowser.extension.builtin.config.set(obj, function() {});
	    }catch(err){
	    }
		var extId ="{75A78384-8765-4852-ABB7-8D5FA8BF48E2}";
		var cmd = {};
		cmd.command = "noSavePwd";
		cmd.pageId = window.currentPageId;
		try {
		qqbrowser.extension.sendRequest(extId, cmd, function() {});
		} catch(e) {
		}
	    window.savePWinfobar.show(false);
	});
		
	savePWinfobar.insert(document.getElementById("info-box"));
	
	// 添加动态调整button位置的div元素
	var flexElement = document.createElement("div");
	flexElement.id = "h-flex";
	
	var btnParent = document.getElementById("savePWinfobar-refButton").parentNode;
	btnParent.insertBefore(flexElement, btnParent.lastChild.previousSibling);
	
};

// added by wilsonteng
function getCloseConfirmConfig(results) {
    var bCloseConfirm = false;
    var options = eval('(' + results + ')');
    if(options.length > 0) {
        bCloseConfirm = options[0].closeWndConfirm;
    }
    eventManager.closeConfirm = bCloseConfirm;
} 
action.afterShow = function(){
//	debugger;
	browserListener.init(); // init all listeners, must before than create first tab
	tabManager.init(); // show tabs	
	view.initNewTabButton(); // init new tabs button
	font.setFont();
	layout.resize();
	tipManager.init(); // 必须在事件的方法绑定前
	eventManager.init(); // 绑定事件
	favbar.init(); // init fav bar 
	menuManager.init(); // init menu
	configManager.init();	// 判断是否存在帐号，有的话显示头像，设置侧边栏状态
		appBox.init(); // 必须在检查登录设置logon之后
	window.onresize = function() {
		layout.resize(); // bind resize event
	};	
	view.initBorderCursor(); // init cursor of border for browser resize	
	view.initLogoMenu(); // 显示登陆前头像菜单	
	browser.account.getCurrent(function(data) {
		var userInfo = eval('(' + data + ')')[0];
		if(userInfo.nUin) { // 有nUin时视为登录
			view.showLogonAvatar(userInfo.strFacePath);
			appBox.logon();
		}
	});	
	aero.regAeroHandler();	
	// add by wilsonteng
	//获取是否需要关闭确认的配置项
	qqbrowser.extension.builtin.config.get(["closeWndConfirm"], getCloseConfirmConfig);
};
